<?php
/**
 * Authentication check for admin pages
 * Include this file at the top of all admin pages to protect them
 */

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once '../functions/data_handler.php';

// Check if admin is logged in
if (!isAdminLoggedIn()) {
    // Redirect to login page
    header('Location: login.php');
    exit;
}

// Check session timeout
if (isset($_SESSION['admin_login_time'])) {
    $sessionTimeout = 3600; // 1 hour
    if (time() - $_SESSION['admin_login_time'] > $sessionTimeout) {
        // Session expired
        adminLogout();
        header('Location: login.php?expired=1');
        exit;
    }
}

// Update last activity time
$_SESSION['admin_login_time'] = time();
?>
