<?php
// Include authentication check
require_once 'auth_check.php';

$pageTitle = 'Dashboard';
$currentPage = 'dashboard';
include 'includes/header.php';
include 'includes/sidebar.php';

// Load data from JSON files
require_once '../functions/data_handler.php';

// Get real data
$products = getProductsData();
$visitors = getVisitorsData();
$leads = getLeadsData();

// Calculate stats
$totalProducts = count($products);
$totalVisitors = count($visitors);
$totalLeads = count($leads);
?>
        <div class="page-header">
            <h1>Dashboard</h1>
            <p class="lead">Welcome back! Here's an overview of your store.</p>
        </div>

        <!-- Simple Stats -->
        <div class="row">
            <div class="col-md-4">
                <div class="card bg-primary text-white">
                    <div class="card-body text-center">
                        <h1 class="display-4"><?php echo $totalVisitors; ?></h1>
                        <h5>Total Visitors</h5>
                        <a href="visitors.php" class="btn btn-light btn-sm mt-2">View Details</a>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card bg-success text-white">
                    <div class="card-body text-center">
                        <h1 class="display-4"><?php echo $totalProducts; ?></h1>
                        <h5>Total Products</h5>
                        <a href="products.php" class="btn btn-light btn-sm mt-2">View Details</a>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card bg-warning text-white">
                    <div class="card-body text-center">
                        <h1 class="display-4"><?php echo $totalLeads; ?></h1>
                        <h5>Total Leads</h5>
                        <a href="leads.php" class="btn btn-light btn-sm mt-2">View Details</a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Test Alerts Section -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5><i class="fas fa-bell mr-2"></i>Test Audio Alerts & Notifications</h5>
                        <p class="mb-0 text-muted">Click the buttons below to test different alert types</p>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-3">
                                <button class="btn btn-warning btn-block mb-2" onclick="testAlert('payment')">
                                    <i class="fas fa-credit-card mr-2"></i>Test Payment Alert
                                </button>
                                <small class="text-muted">Urgent beep for payment submissions</small>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-info btn-block mb-2" onclick="testAlert('visitor')">
                                    <i class="fas fa-user mr-2"></i>Test Visitor Alert
                                </button>
                                <small class="text-muted">Medium beep for new visitors</small>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-success btn-block mb-2" onclick="testAlert('success')">
                                    <i class="fas fa-check mr-2"></i>Test Success Alert
                                </button>
                                <small class="text-muted">High beep for successful actions</small>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-secondary btn-block mb-2" onclick="testAlert('activity')">
                                    <i class="fas fa-mouse-pointer mr-2"></i>Test Activity Alert
                                </button>
                                <small class="text-muted">Low beep for visitor activity</small>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <button class="btn btn-primary btn-block mb-2" onclick="testNotification('Payment Alert!', 'New payment received from John Doe - $299.99')">
                                    <i class="fas fa-bell mr-2"></i>Test Payment Notification
                                </button>
                            </div>
                            <div class="col-md-6">
                                <button class="btn btn-info btn-block mb-2" onclick="testNotification('New Visitor', 'Visitor #V001 connected from New York')">
                                    <i class="fas fa-user-plus mr-2"></i>Test Visitor Notification
                                </button>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-6">
                                <button class="btn btn-success btn-block mb-2" onclick="testNotification('OTP Received', 'OTP code 123456 received from visitor')">
                                    <i class="fas fa-key mr-2"></i>Test OTP Notification
                                </button>
                            </div>
                            <div class="col-md-6">
                                <button class="btn btn-warning btn-block mb-2" onclick="testAllAlerts()">
                                    <i class="fas fa-play mr-2"></i>Test All Alerts (Sequence)
                                </button>
                            </div>
                        </div>
                        
                        <div class="alert alert-info mt-3">
                            <h6><i class="fas fa-info-circle mr-2"></i>Testing Instructions:</h6>
                            <ul class="mb-0">
                                <li><strong>Audio Alerts:</strong> Click any alert button to hear the corresponding beep sound</li>
                                <li><strong>Browser Notifications:</strong> Make sure to allow notifications when prompted</li>
                                <li><strong>Test All:</strong> Plays all alert types in sequence with a 1-second delay</li>
                                <li><strong>Volume:</strong> Adjust your system volume to hear the alerts clearly</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
</div>
</div>

<script>
// Audio alert function for testing
function playAlertSound(type) {
    try {
        const audioContext = new (window.AudioContext || window.webkitAudioContext)();
        
        let frequency, duration, volume;
        
        switch(type) {
            case 'payment':
                frequency = 800;
                duration = 0.3;
                volume = 0.5;
                break;
            case 'visitor':
                frequency = 600;
                duration = 0.2;
                volume = 0.3;
                break;
            case 'success':
                frequency = 1000;
                duration = 0.1;
                volume = 0.4;
                break;
            case 'activity':
                frequency = 400;
                duration = 0.1;
                volume = 0.2;
                break;
            default:
                frequency = 500;
                duration = 0.2;
                volume = 0.3;
        }
        
        const oscillator = audioContext.createOscillator();
        const gainNode = audioContext.createGain();
        
        oscillator.connect(gainNode);
        gainNode.connect(audioContext.destination);
        
        oscillator.frequency.setValueAtTime(frequency, audioContext.currentTime);
        oscillator.type = 'sine';
        
        gainNode.gain.setValueAtTime(0, audioContext.currentTime);
        gainNode.gain.linearRampToValueAtTime(volume, audioContext.currentTime + 0.01);
        gainNode.gain.exponentialRampToValueAtTime(0.001, audioContext.currentTime + duration);
        
        oscillator.start(audioContext.currentTime);
        oscillator.stop(audioContext.currentTime + duration);
        
    } catch (error) {
        alert('Audio not supported in this browser');
    }
}

// Browser notification function for testing
function showBrowserNotification(title, message) {
    if ('Notification' in window && Notification.permission === 'granted') {
        const notification = new Notification(title, {
            body: message,
            icon: '/assets/logo.svg',
            tag: 'test-alert',
            requireInteraction: false,
            silent: false
        });
        
        setTimeout(() => {
            notification.close();
        }, 3000);
        
        notification.onclick = function() {
            window.focus();
            notification.close();
        };
    } else if ('Notification' in window && Notification.permission === 'default') {
        Notification.requestPermission().then(function(permission) {
            if (permission === 'granted') {
                showBrowserNotification(title, message);
            } else {
                alert('Notifications are blocked. Please enable them in your browser settings.');
            }
        });
    } else {
        alert('Notifications are not supported in this browser');
    }
}

// Test functions
function testAlert(type) {
    playAlertSound(type);
    
    // Show visual feedback
    const button = event.target;
    const originalText = button.innerHTML;
    button.innerHTML = '<i class="fas fa-volume-up mr-2"></i>Playing...';
    button.disabled = true;
    
    setTimeout(() => {
        button.innerHTML = originalText;
        button.disabled = false;
    }, 1000);
}

function testNotification(title, message) {
    showBrowserNotification(title, message);
    
    // Show visual feedback
    const button = event.target;
    const originalText = button.innerHTML;
    button.innerHTML = '<i class="fas fa-bell mr-2"></i>Sent!';
    button.disabled = true;
    
    setTimeout(() => {
        button.innerHTML = originalText;
        button.disabled = false;
    }, 2000);
}

function testAllAlerts() {
    const button = event.target;
    const originalText = button.innerHTML;
    button.innerHTML = '<i class="fas fa-play mr-2"></i>Playing Sequence...';
    button.disabled = true;
    
    // Play all alert types with delays
    setTimeout(() => { playAlertSound('payment'); }, 0);
    setTimeout(() => { playAlertSound('visitor'); }, 1000);
    setTimeout(() => { playAlertSound('success'); }, 2000);
    setTimeout(() => { playAlertSound('activity'); }, 3000);
    
    // Show notifications too
    setTimeout(() => { showBrowserNotification('Payment Alert!', 'Test payment notification'); }, 500);
    setTimeout(() => { showBrowserNotification('New Visitor', 'Test visitor notification'); }, 1500);
    setTimeout(() => { showBrowserNotification('Success!', 'Test success notification'); }, 2500);
    setTimeout(() => { showBrowserNotification('Activity', 'Test activity notification'); }, 3500);
    
    setTimeout(() => {
        button.innerHTML = originalText;
        button.disabled = false;
    }, 4000);
}

// Request notification permission on page load
document.addEventListener('DOMContentLoaded', function() {
    if ('Notification' in window) {
        Notification.requestPermission();
    }
});
</script>

<?php
include 'includes/footer.php';
?>
