<?php
$pageTitle = 'Reports';
$currentPage = 'reports';
include 'includes/header.php';
include 'includes/sidebar.php';
?>
        <div class="page-header">
            <h1>Reports & Analytics</h1>
            <p class="lead">Comprehensive reports and analytics for your business.</p>
        </div>

        <!-- Summary Stats -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="summary-stat positive">
                    <h4>+15%</h4>
                    <p>Visitor Growth</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="summary-stat neutral">
                    <h4>567</h4>
                    <p>Total Products</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="summary-stat positive">
                    <h4>+8%</h4>
                    <p>Lead Conversion</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="summary-stat negative">
                    <h4>-2%</h4>
                    <p>Bounce Rate</p>
                </div>
            </div>
        </div>

        <!-- Visitor Trends Chart -->
        <div class="report-card">
            <h3><i class="fas fa-users mr-2"></i>Visitor Trends (Last 7 Days)</h3>
            <div class="chart-container">
                <canvas id="visitorTrendsChart"></canvas>
            </div>
        </div>

        <!-- Product Performance Chart -->
        <div class="report-card">
            <h3><i class="fas fa-box mr-2"></i>Top Performing Products</h3>
            <div class="chart-container">
                <canvas id="productPerformanceChart"></canvas>
            </div>
        </div>

        <!-- Lead Status Chart & Table -->
        <div class="row">
            <div class="col-md-6">
                <div class="report-card">
                    <h3><i class="fas fa-user-plus mr-2"></i>Lead Status Distribution</h3>
                    <div class="chart-container">
                        <canvas id="leadStatusChart"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="report-card">
                    <h3><i class="fas fa-table mr-2"></i>Recent Lead Activity</h3>
                    <div class="table-responsive">
                        <table class="table table-sm table-hover">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>John Doe</td>
                                    <td><span class="badge badge-success">New</span></td>
                                    <td>2023-10-20</td>
                                </tr>
                                <tr>
                                    <td>Jane Smith</td>
                                    <td><span class="badge badge-warning">Contacted</span></td>
                                    <td>2023-10-19</td>
                                </tr>
                                <tr>
                                    <td>Peter Jones</td>
                                    <td><span class="badge badge-info">Converted</span></td>
                                    <td>2023-10-18</td>
                                </tr>
                                <tr>
                                    <td>Emily White</td>
                                    <td><span class="badge badge-success">New</span></td>
                                    <td>2023-10-17</td>
                                </tr>
                                <tr>
                                    <td>Michael Brown</td>
                                    <td><span class="badge badge-danger">Closed</span></td>
                                    <td>2023-10-16</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </main>
</div>
</div>

<!-- Download Report Modal -->
<div class="modal fade" id="downloadReportModal" tabindex="-1" aria-labelledby="downloadReportModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="downloadReportModalLabel">Download Report</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Select the report you want to download and the format.</p>
                <div class="form-group">
                    <label for="reportType">Report Type:</label>
                    <select class="form-control" id="reportType">
                        <option value="visitors">Visitor Trends</option>
                        <option value="products">Product Performance</option>
                        <option value="leads">Lead Status</option>
                        <option value="summary">Full Summary</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="reportFormat">Format:</label>
                    <select class="form-control" id="reportFormat">
                        <option value="csv">CSV</option>
                        <option value="json">JSON</option>
                        <option value="pdf">PDF</option>
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="confirmDownloadReportBtn">Download</button>
            </div>
        </div>
    </div>
</div>

<?php
include 'includes/footer.php';
?>
