<?php
/**
 * Backend Configuration
 * Configure Node.js server URLs for different environments
 */

// Environment detection
$isLocalhost = (strpos($_SERVER['HTTP_HOST'], 'localhost') !== false || 
                strpos($_SERVER['HTTP_HOST'], '127.0.0.1') !== false);

// Backend server configuration
if ($isLocalhost) {
    // Local development
    define('WEBSOCKET_URL', 'ws://localhost:3001/ws');
    define('API_URL', 'http://localhost:3002/api/visitors');
    define('SEND_REQUEST_URL', 'http://localhost:3001/api/send-request');
} else {
    // Production (VPS) - Using your VPS IP
    define('WEBSOCKET_URL', 'ws://66.29.135.229:3001/ws');
    define('API_URL', 'http://66.29.135.229:3002/api/visitors');
    define('SEND_REQUEST_URL', 'http://66.29.135.229:3001/api/send-request');
}

// Debug mode (set to false in production)
define('BACKEND_DEBUG', $isLocalhost);

// Log backend configuration
if (BACKEND_DEBUG) {
    error_log("Backend Config - WebSocket: " . WEBSOCKET_URL);
    error_log("Backend Config - API: " . API_URL);
    error_log("Backend Config - Send Request: " . SEND_REQUEST_URL);
}
?>
