<?php
// Header include file for Flanco website
// This file contains the HTML head section and header navigation
?>
<!DOCTYPE html>
<html lang="ro">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Flanco Smart Discounter</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
        }

        /* Top Informational Bar */
        .top-bar {
            background-color: white;
            padding: 10px 0;
            text-align: center;
            border-bottom: 1px solid #e0e0e0;
        }

        .top-bar-content {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 15px;
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }

        .top-bar-text {
            color: #333;
            font-size: 14px;
        }

        .details-btn {
            background-color: #ffd700;
            color: #333;
            border: none;
            padding: 8px 16px;
            border-radius: 24px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;

        }

        /* Main Navigation Bar */
        .flanco-main-nav {
            background-color: #1A237E;
            padding: 15px 0;
            position: sticky;
            top: 0;
            z-index: 1000;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .flanco-nav-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        /* Left Section - Menu and Logo */
        .flanco-left-section {
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .flanco-menu-toggle {
            display: flex;
            flex-direction: column;
            align-items: center;
            color: white;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .flanco-menu-toggle:hover {
            transform: scale(1.05);
        }

        .flanco-hamburger {
            width: 20px;
            height: 15px;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            margin-bottom: 5px;
        }

        .flanco-hamburger span {
            width: 100%;
            height: 2px;
            background-color: white;
            display: block;
            transition: all 0.3s ease;
        }

        .flanco-menu-text {
            font-size: 12px;
            color: white;
            font-weight: 500;
        }

        .flanco-logo-section {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .flanco-logo {
            text-decoration: none;
            display: block;
            transition: transform 0.3s ease;
        }
        
        .flanco-logo:hover {
            transform: scale(1.05);
        }

        .flanco-logo-img {
            width: 200px;
            height: 50px;
            object-fit: cover;
            object-position: center;
            margin: 0;
            padding: 0;
            display: block;
        }

        /* Middle Section - Search */
        .flanco-search-section {
            flex: 1;
            max-width: 500px;
            margin: 0 40px;
            position: relative;
        }

        .flanco-search-input {
            width: 100%;
            padding: 12px 50px 12px 20px;
            border: none;
            border-radius: 25px;
            font-size: 16px;
            outline: none;
            background-color: white;
            transition: all 0.3s ease;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        
        .flanco-search-input:focus {
            box-shadow: 0 4px 15px rgba(0,0,0,0.2);
            transform: translateY(-1px);
        }

        .flanco-search-input::placeholder {
            color: #999;
        }

        .flanco-search-icon {
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
            color: #666;
            font-size: 18px;
            transition: color 0.3s ease;
        }
        
        .flanco-search-icon:hover {
            color: #1A237E;
        }

        /* Right Section - User Actions */
        .flanco-right-section {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .flanco-nav-button {
            background-color: #1A237E;
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 6px;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 14px;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .flanco-nav-button::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }
        
        .flanco-nav-button:hover::before {
            left: 100%;
        }

        .flanco-nav-button:hover {
            background-color: #283593;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.2);
        }

        .flanco-nav-button i {
            font-size: 16px;
        }

        .flanco-dropdown-arrow {
            font-size: 12px;
            margin-left: 5px;
        }

        .flanco-cart-badge {
            position: relative;
        }

        .flanco-badge {
            position: absolute;
            top: -5px;
            right: -5px;
            background-color: #f44336;
            color: white;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
            font-weight: bold;
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.1); }
            100% { transform: scale(1); }
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .flanco-nav-container {
                flex-direction: column;
                gap: 15px;
            }

            .flanco-search-section {
                margin: 0;
                max-width: 100%;
                width: 100%;
            }

            .flanco-search-input {
                width: 100%;
            }

            .flanco-right-section {
                flex-wrap: wrap;
                justify-content: center;
            }
        }
    </style>
    <!-- Link to existing CSS files -->
    <link rel="stylesheet" href="css/custom.min.css">
    <link rel="stylesheet" href="css/styles-l.min.css">
    <link rel="stylesheet" href="css/styles-m.min.css">
    <link rel="stylesheet" href="css/listing.min.css">
    <link rel="stylesheet" href="css/previzualizare.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <!-- Top Informational Bar -->
    <div class="top-bar">
        <div class="top-bar-content">
            <span class="top-bar-text">Retur gratuit în 45 de zile pentru produsele livrate de Flanco Smart Discounter</span>
            <button class="details-btn">Vezi detalii</button>
        </div>
    </div>

    <!-- Main Navigation Bar -->
    <nav class="flanco-main-nav">
        <div class="flanco-nav-container">
            <!-- Left Section - Menu and Logo -->
            <div class="flanco-left-section">
                <div class="flanco-menu-toggle">
                    <div class="flanco-hamburger">
                        <span></span>
                        <span></span>
                        <span></span>
                    </div>
                    <span class="flanco-menu-text">Produse</span>
                </div>
                
                <div class="flanco-logo-section">
                    <a href="#" class="flanco-logo">
                        <img src="assets/logo.svg" alt="Flanco Smart Discounter" class="flanco-logo-img">
                    </a>
                </div>
            </div>

            <!-- Middle Section - Search -->
            <div class="flanco-search-section">
                <input type="text" class="flanco-search-input" placeholder="Caută în magazin...">
                <i class="fas fa-search flanco-search-icon"></i>
            </div>

            <!-- Right Section - User Actions -->
            <div class="flanco-right-section">
                <button class="flanco-nav-button">
                    <i class="fas fa-map-marker-alt"></i>
                    Urmăreşte comanda
                </button>
                
                <button class="flanco-nav-button">
                    <i class="fas fa-user"></i>
                    Contul meu
                    <i class="fas fa-chevron-down flanco-dropdown-arrow"></i>
                </button>
                
                <button class="flanco-nav-button flanco-cart-badge">
                    <i class="fas fa-shopping-cart"></i>
                    Coșul meu
                    <i class="fas fa-chevron-down flanco-dropdown-arrow"></i>
                    <span class="flanco-badge">0</span>
                </button>
            </div>
        </div>
    </nav>
</body>
</html>
