@echo off
echo Starting AlexShopClone WebSocket Server...

REM Check if Node.js is available
node --version >nul 2>&1
if errorlevel 1 (
    echo Error: Node.js is not installed or not in PATH
    pause
    exit /b 1
)

REM Check if npm is available
npm --version >nul 2>&1
if errorlevel 1 (
    echo Error: npm is not installed or not in PATH
    pause
    exit /b 1
)

REM Install dependencies if node_modules doesn't exist
if not exist "node_modules" (
    echo Installing dependencies...
    npm install --production
)

REM Create logs directory if it doesn't exist
if not exist "logs" mkdir logs

REM Start the server
echo Starting WebSocket server on port 3001...
node websocket_server.js

pause
