#!/bin/bash

# AlexShopClone WebSocket Server Startup Script
# For cPanel deployment

echo "Starting AlexShopClone WebSocket Server..."

# Check if Node.js is available
if ! command -v node &> /dev/null; then
    echo "Error: Node.js is not installed or not in PATH"
    exit 1
fi

# Check if npm is available
if ! command -v npm &> /dev/null; then
    echo "Error: npm is not installed or not in PATH"
    exit 1
fi

# Install dependencies if node_modules doesn't exist
if [ ! -d "node_modules" ]; then
    echo "Installing dependencies..."
    npm install --production
fi

# Create logs directory if it doesn't exist
mkdir -p logs

# Set proper permissions
chmod 755 websocket_server.js
chmod 644 database/*.json 2>/dev/null || true
chmod 644 data/*.json 2>/dev/null || true

# Start the server
echo "Starting WebSocket server on port 3001..."
node websocket_server.js
